/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/



#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "surrender.h"

SSettingsStruct *SSettings = 0;

void SSettingsStruct::Load() {
	SettingsLoader::Load();
	LoadFloat(percentneededwin,"PercentNeededToPass");
	LoadFloat(percentneededvote,"PercentOfPlayersNeededToVote");
	LoadInt(surrendervotelastforinseconds,"surrendervotelastforinseconds");
}


void Plugin_Load() {
	SSettings = new SSettingsStruct("surrender.ini");
}





bool svoting = false;
int votingteam = 2;
bool shasvoted[128];
int syes = 0;
int sno = 0;

class surrenderChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		if(!svoting){
votingteam = Get_Team(ID);
if (votingteam == 1){
Console_Input(StrFormat("msg %s has started a vote for GDI to surrender, all GDI players please either !surrender yes or !surrender no.",Get_Player_Name_By_ID(ID)).c_str());
for(int i = 0; i < 128; i++){
							if(Get_Player_Type(Get_GameObj(i)) == 1){
			Console_Input(StrFormat("ppage %d A has started for your team to surrender, please either !surrender yes or !surrender no.",i).c_str());
							}
}
}
else if(votingteam == 0){
Console_Input(StrFormat("msg %s has started a vote for Nod to surrender, all Nod players please either !surrender yes or !surrender no.",Get_Player_Name_By_ID(ID)).c_str());
for(int i = 0; i < 128; i++){
							if(Get_Player_Type(Get_GameObj(i)) == 0){
			Console_Input(StrFormat("ppage %d A has started for your team to surrender, please either !surrender yes or !surrender no.",i).c_str());
							}
}
}
svoting = true;
GameObject *votething = Commands->Create_Object("Invisible_Object",Vector3(0.0f,0.0f,0.0f));
Commands->Attach_Script(votething,"reb_surrender_timer","");
}
else{
Console_Input(StrFormat("ppage %d You have tried to start a team surrender vote, but one is already in progress, please wait.",ID).c_str());
		}
	}
};
ChatCommandRegistrant<surrenderChatCommand> surrenderChatCommandReg("!Giveup;!GIVEUP;!giveup",CHATTYPE_ALL,0,GAMEMODE_ALL);



bool basedestructionendsgame = The_Cnc_Game()->BaseDestructionEndsGame;

void reb_surrender_timer::Created(GameObject *obj){
Commands->Start_Timer(obj, this, 25.0f, 1);
Commands->Start_Timer(obj, this, (float)SSettings->surrendervotelastforinseconds, 2);
}


void reb_surrender_timer::Timer_Expired(GameObject *obj, int number){
	if(number == 1){
		if(svoting){
			if(votingteam == 1){
			Console_Input(StrFormat("msg The poll for GDI to surrender has %i yes votes and %i no votes.",syes,sno).c_str());
		Commands->Start_Timer(obj, this, 25.0f, 1);
			}
			else if(votingteam == 2){
			Console_Input(StrFormat("msg The poll for Nod to surrender has %i yes votes and %i no votes.",syes,sno).c_str());
		Commands->Start_Timer(obj, this, 25.0f, 1);
			}
		}
	}
	else if(number == 2){
//Just a little check here, stops the vote from happening if the server gameover'd while a vote was happening.
		if(svoting){
		//Vote has ended
Console_Input(StrFormat("msg The poll has ended with %i yes votes and %i no votes.",syes,sno).c_str());
if(((100/Get_Team_Player_Count(votingteam))*(syes + sno)) >= SSettings->percentneededvote){
if(((100/(syes + sno)) * syes) >= SSettings->percentneededwin){
//Vote has passed
	Console_Input(StrFormat("msg The poll has passed, gameovering...").c_str());
basedestructionendsgame = The_Cnc_Game()->BaseDestructionEndsGame;
The_Cnc_Game()->BaseDestructionEndsGame = 1;
Destroy_Base(votingteam);
}
else{
//Vote has not passed
	Console_Input(StrFormat("msg The poll has not passed, the poll needs %f percent or more of the vote to pass.",SSettings->percentneededwin).c_str());
}
}
else{
Console_Input(StrFormat("msg The poll has not passed, the poll needs %f percent or more of the team to actually participate in the vote.",SSettings->percentneededwin).c_str());
}
svoting = false;
			for(int i = 0; i < 128; i++)
	{
		shasvoted[i] = false;
	}
syes = 0;
sno = 0;
	}
Commands->Destroy_Object(obj);
Destroy_Script();
}
}

ScriptRegistrant<reb_surrender_timer> reb_surrender_timer_Registrant("reb_surrender_timer","");





class surrender2ChatCommand : public ChatCommandClass {
	void Triggered(int ID,const TokenClass &Text,int ChatType) {
		if(svoting){
			if(Get_Team(ID) == votingteam){
				if(shasvoted[ID] == false){
			if (!Text[1].empty()) {

std::string sdecision = Text[1].c_str();

//code here to work out if they vote yes or no, and add to the yes and no variables accordingly
if(sdecision == "no" || sdecision == "No" || sdecision == "NO"){
sno = sno + 1;
Console_Input(StrFormat("ppage %d Your vote has been counted, thankyou.",ID).c_str());
Console_Input(StrFormat("msg %s has just voted against the surrender.",Get_Player_Name_By_ID(ID)).c_str());
shasvoted[ID] = true;
}
else if (sdecision == "yes" || sdecision == "Yes" || sdecision == "YES"){
syes = syes + 1;
Console_Input(StrFormat("ppage %d Your vote has been counted, thankyou.",ID).c_str());
Console_Input(StrFormat("msg %s has just voted in favour of the surrender.",Get_Player_Name_By_ID(ID)).c_str());
shasvoted[ID] = true;
}
/*
If you're reading the following lines of text, then you are no doubt a programmer. I ask you to please keep this
easter-egg a secret. A player might find it one day and it'll be funny. So don't ruin it please. Thankyou. :-)
*/
else if (sdecision == "Spoony" || sdecision == "spoony" || sdecision == "SPOONY"){
Console_Input(StrFormat("ppage %d You just found the easter egg, Spooney requested this plug-in be written, and as an easter-egg this text is his homage. Also, did you know Spooney dodged several 1v1's with troopm02? lol...",ID).c_str());
}
else{
Console_Input(StrFormat("ppage %d The server did not understand your vote, please either \"!surrender yes\" or \"!surrender no\".",ID).c_str());
}
}
}
		else{
Console_Input(StrFormat("ppage %d You have already voted once.",ID).c_str());
		}
		}
			else{
Console_Input(StrFormat("ppage %d This is not your teams vote. You cannot vote for the other team to surrender.",ID).c_str());
			}
}
		else{
Console_Input(StrFormat("ppage %d There is no vote in progress to surrender, to start one type \"!giveup\"",ID).c_str());
		}
}
};
ChatCommandRegistrant<surrender2ChatCommand> surrender2ChatCommandReg("!surrender;!Surrender;!SURRENDER",CHATTYPE_ALL,1,GAMEMODE_ALL);






void Plugin_Unload() {
	delete SSettings;
}



extern "C" {


DLLEXPORT void SSGM_Level_Loaded_Hook() {
	SSettings->Load();
The_Cnc_Game()->BaseDestructionEndsGame = basedestructionendsgame;
svoting = false;
			for(int i = 0; i < 128; i++){
		shasvoted[i] = false;
			}
			syes = 0;
			sno = 0;
			if(svoting){
svoting = false;
printf("Vote for surrender was cancelled\n");
}
}



}


